﻿var requestLogs = {
    context: $(".v-requestLogs"),
    datatable: null,
    refreshDataTable: function () {
        requestLogs.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        this.datatable = $(".h-requestLogsTable", requestLogs.context).a4datatable({
            height: "full",
            stateKey: "RequestLogs",
            ajaxAction: a4.getAction("GetRequestLogs", "Diagnostics", "Settings"),
            columns: [
                { "Name": "Id", "Title": resources.Id, "Data": "Id", "Class": "id", "Width": "60px" },
                { "Name": "Url", "Title": resources.Url, "Data": "Url" },
                { "Name": "StartDate", "Title": resources.StartDate, "Data": "StartDate", "Type": "datetime", "Width": "130px" },
                { "Name": "EndDate", "Title": resources.EndDate, "Data": "EndDate", "Type": "datetime", "Width": "130px" },
                { "Name": "Duration", "Title": resources.Duration, "Data": "Duration" },
                { "Name": "ApplicationName", "Title": resources.Application, "Data": "Application" },
                { "Name": "MachineName", "Title": resources.Server, "Data": "Server" },
                { "Name": "ClientIp", "Title": resources.ClientIp, "Data": "ClientIp" },
                { "Name": "ClientBrowser", "Title": resources.ClientBrowser, "Data": "ClientBrowser" }
            ],
            localizableTexts: { "Search": resources.SearchRequestLogs },
            defaultSorting: { Column: "Id", Ascending: false },
            advancedFilter: true,
            lengthMenu: [
                [10, 20, 50, 100, 500, 1000],
                ['10', '20', '50', '100', '500', '1000']
            ],
            pagingType: "input"
        });
    },
    bindEvents: function () {
        requestLogs.context.on("click", ".h-exportLogs", function () {
            var tableParams = requestLogs.datatable.a4datatable("getTableParams");
            var link = a4.getAction("ExportRequestLogs", "Diagnostics", "Settings", { tableParams: JSON.stringify(tableParams) });

            a4.showBusyBox();

            a4.callServerMethod(link, {},
            function (result) {
                a4.hideBusyBox();
                window.location = a4.getAction("GetExportRequestLogsFile", "Diagnostics", "Settings", { filename: result });
            },
            function (error) {
                a4.onAjaxPageMethodError(error);
            });
        });

        requestLogs.context.on("click", ".h-clearLogs", function () {
            modalDialog.showConfirmDialog(confirmClearLogsResources, function () {
                a4.callServerMethod(a4.getAction("ClearRequestLogs", "Diagnostics", "Settings"), {},
                    function (result) {
                        requestLogs.refreshDataTable();
                    });
            }, 220, 500);
        });
    }
}

$(document).ready(function () {
    if (requestLogs.context.length > 0) {
        requestLogs.initializeDataTable();
        requestLogs.bindEvents();
    }
});


